<?php
session_start();
require_once '../config/db.php';
require_once '../auth/auth.php';

header('Content-Type: application/json');

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Not authorized']);
    exit();
}

// Get the search term
$term = isset($_GET['term']) ? trim($_GET['term']) : '';

if (empty($term)) {
    echo json_encode(['success' => false, 'message' => 'No search term provided']);
    exit();
}

try {
    // Search customers by name, email, or phone
    $query = "
        SELECT id, name, email, phone, credit_limit
        FROM customers 
        WHERE name LIKE ? 
        OR email LIKE ?
        OR phone LIKE ?
        ORDER BY name 
        LIMIT 10
    ";
    
    $searchTerm = "%{$term}%";
    $stmt = $pdo->prepare($query);
    $stmt->execute([$searchTerm, $searchTerm, $searchTerm]);
    $customers = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        'success' => true,
        'customers' => $customers
    ]);
} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage()
    ]);
} 